( function( blocks, element, blockEditor, components ) {
    var el = element.createElement;
    var InspectorControls = blockEditor.InspectorControls;
    var TextControl = components.TextControl;
    var CheckboxControl = components.CheckboxControl;

    blocks.registerBlockType( 'piwigo-integration/gallery', {
        title: 'Piwigo Gallery',
        icon: 'images-alt2',
        category: 'common',
        attributes: {
            category: {
                type: 'string',
                default: '1',
            },
            num_photos: {
                type: 'number',
                default: 24,
            },
            num_columns: {
                type: 'number',
                default: 4,
            },
            showButton: {
                type: 'boolean',
                default: true,
            },
        },
        edit: function( props ) {
            var category = props.attributes.category;
            var num_photos = props.attributes.num_photos;
            var num_columns = props.attributes.num_columns;
            var showButton = props.attributes.showButton;

            function onChangeCategory( newCategory ) {
                props.setAttributes( { category: newCategory } );
            }

            function onChangeNumPhotos( newNumPhotos ) {
                props.setAttributes( { num_photos: parseInt(newNumPhotos) } );
            }

            function onChangeNumColumns( newNumColumns ) {
                props.setAttributes( { num_columns: parseInt(newNumColumns) } );
            }

            function onChangeShowButton( newShowButton ) {
                props.setAttributes( { showButton: newShowButton } );
            }

            return [
                el( InspectorControls, {},
                    el( TextControl, {
                        label: 'Category ID',
                        value: category,
                        onChange: onChangeCategory
                    }),
                    el( TextControl, {
                        label: 'Number of Photos',
                        type: 'number',
                        value: num_photos,
                        onChange: onChangeNumPhotos
                    }),
                    el( TextControl, {
                        label: 'Number of Columns',
                        type: 'number',
                        value: num_columns,
                        onChange: onChangeNumColumns
                    }),
                    el( CheckboxControl, {
                        label: 'Show "View Gallery" Button',
                        checked: showButton,
                        onChange: onChangeShowButton
                    })
                ),
                el( 'div', { className: 'piwigo-gallery-block' },
                    'Piwigo Gallery - Category ID: ' + category + ', Number of Photos: ' + num_photos + ', Number of Columns: ' + num_columns + ', Show Button: ' + (showButton ? 'Yes' : 'No')
                )
            ];
        },
        save: function( props ) {
            return el( 'div', { className: 'piwigo-gallery-block' },
                '[piwigo_gallery category="' + props.attributes.category + '" num_photos="' + props.attributes.num_photos + '" num_columns="' + props.attributes.num_columns + '" show_button="' + props.attributes.showButton + '"]'
            );
        },
    } );
} )( window.wp.blocks, window.wp.element, window.wp.blockEditor, window.wp.components );
