<?php
/*
Plugin Name: MDQ Sorteos
Description: Un plugin para realizar sorteos aleatorios entre una lista de nombres. El sorteo puede realizarse tanto en el frontend como en el backend.
Version: 1.5
Author: Diego Lazo
Author URI: https://www.mundodequimeras.com
Text Domain: mdq-sorteos
License: GPLv2 or later
*/

function mdq_sorteos_menu() {
    add_menu_page(
        'MDQ Sorteos',
        'MDQ Sorteos',
        'manage_options',
        'mdq-sorteos',
        'mdq_sorteos_admin_page',
        'dashicons-randomize',
        6
    );
}

add_action('admin_menu', 'mdq_sorteos_menu');

function mdq_sorteos_admin_page() {
    ?>
    <div class="wrap mdq-sorteos-backend">
        <h1 style="text-align:center;">MDQ Sorteos</h1>
        <p style="text-align:center;">
            <img src="<?php echo plugin_dir_url(__FILE__); ?>MDQ Sorteos.webp" alt="MDQ Sorteos Cover Image" style="width: 250px; height: 250px; border-radius: 15px;">
        </p>
        <h2>Descripcion del Plugin</h2>
        <p>MDQ Sorteos es un plugin de WordPress disenado para facilitar la realizacion de sorteos aleatorios entre una lista de nombres. Perfecto para concursos, sorteos, y cualquier situacion donde necesites elegir un ganador al azar.</p>
        <h2>Funcionalidades Principales</h2>
        <ul>
            <li>Realiza sorteos aleatorios con una cuenta regresiva emocionante.</li>
            <li>Incluye una animacion de confetti al mostrar el ganador.</li>
            <li>Diseno responsive que se adapta a cualquier dispositivo.</li>
            <li>Facil integracion con cualquier pagina o entrada utilizando el shortcode.</li>
        </ul>
        <h2>Como Usar el Plugin</h2>
        <p>Para utilizar el plugin, simplemente inserta el siguiente shortcode en cualquier pagina o entrada:</p>
        <code>[mdq_sorteos]</code>
        <p>Esto generara un formulario donde los usuarios pueden ingresar nombres, realizar un sorteo y ver el nombre del ganador con una animacion de confetti.</p>
        <h2>Soporte y Mas Informacion</h2>
        <p>Si necesitas ayuda o mas informacion, visita <a href="https://www.mundodequimeras.com" target="_blank">nuestro sitio web</a>.</p>
    </div>
    <style>
        .mdq-sorteos-backend {
            font-family: 'Poppins', sans-serif;
            line-height: 1.6;
        }
        .mdq-sorteos-backend h1 {
            font-size: 2.5em;
            color: #007bff;
        }
        .mdq-sorteos-backend h2 {
            font-size: 1.8em;
            margin-top: 20px;
            color: #333;
        }
        .mdq-sorteos-backend p, .mdq-sorteos-backend ul {
            font-size: 1.2em;
            color: #555;
        }
        .mdq-sorteos-backend ul {
            list-style-type: disc;
            margin-left: 20px;
        }
    </style>
    <?php
}

function mdq_sorteos_shortcode() {
    // Obtiene la ruta del archivo HTML
    $html_file = plugin_dir_path(__FILE__) . 'mdq-sorteos.html';

    // Verifica si el archivo existe antes de intentar cargarlo
    if (file_exists($html_file)) {
        // Carga el contenido del archivo HTML
        $output = file_get_contents($html_file);
    } else {
        // Mensaje de error si el archivo no se encuentra
        $output = '<p>Lo siento, el formulario de sorteos no est disponible en este momento.</p>';
    }

    return $output;
}

add_shortcode('mdq_sorteos', 'mdq_sorteos_shortcode');
