<?php
/**
 * Plugin Name: MDQ Botón de Mensajería
 * Description: Plugin para agregar un botón de mensajería flotante a tu sitio web de WordPress.
 * Version: 1.11
 * Author: Diego Lazo
 * Author URI: https://www.mundodequimeras.com
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

// Evitar acceso directo
if (!defined('ABSPATH')) {
    exit;
}

// Registrar el menú de configuración del plugin
add_action('admin_menu', 'mdq_messaging_button_menu');
function mdq_messaging_button_menu() {
    add_menu_page(
        'MDQ Botón de Mensajería',
        'MDQ Botón de Mensajería',
        'manage_options',
        'mdq-messaging-button',
        'mdq_messaging_button_config_page',
        'dashicons-email',
        100
    );
}

// Página de configuración del plugin
function mdq_messaging_button_config_page() {
    if (!current_user_can('manage_options')) {
        return;
    }

    // Verificación de nonce para seguridad
    if (isset($_POST['mdq_messaging_button_guardar']) && check_admin_referer('mdq_messaging_button_guardar_nonce')) {
        if (isset($_POST['mdq_messaging_numero'])) {
            update_option('mdq_messaging_numero', sanitize_text_field(wp_unslash($_POST['mdq_messaging_numero'])));
        }
        if (isset($_POST['mdq_messaging_icono'])) {
            update_option('mdq_messaging_icono', esc_url_raw(wp_unslash($_POST['mdq_messaging_icono'])));
        }
        if (isset($_POST['mdq_messaging_posicion'])) {
            update_option('mdq_messaging_posicion', sanitize_text_field(wp_unslash($_POST['mdq_messaging_posicion'])));
        }
        update_option('mdq_messaging_mostrar_movil', isset($_POST['mdq_messaging_mostrar_movil']) ? 1 : 0);
        update_option('mdq_messaging_mostrar_escritorio', isset($_POST['mdq_messaging_mostrar_escritorio']) ? 1 : 0);
        if (isset($_POST['mdq_messaging_mensaje'])) {
            update_option('mdq_messaging_mensaje', sanitize_text_field(wp_unslash($_POST['mdq_messaging_mensaje'])));
        }
        if (isset($_POST['mdq_messaging_tamano'])) {
            update_option('mdq_messaging_tamano', sanitize_text_field(wp_unslash($_POST['mdq_messaging_tamano'])));
        }
        if (isset($_POST['mdq_messaging_altura'])) {
            update_option('mdq_messaging_altura', sanitize_text_field(wp_unslash($_POST['mdq_messaging_altura'])));
        }
        if (isset($_POST['mdq_messaging_animacion'])) {
            update_option('mdq_messaging_animacion', sanitize_text_field(wp_unslash($_POST['mdq_messaging_animacion'])));
        }
        if (isset($_POST['mdq_messaging_mensajes_paginas'])) {
            update_option('mdq_messaging_mensajes_paginas', sanitize_textarea_field(wp_unslash($_POST['mdq_messaging_mensajes_paginas'])));
        }
        update_option('mdq_messaging_visibilidad_usuario', isset($_POST['mdq_messaging_visibilidad_usuario']) ? sanitize_text_field(wp_unslash($_POST['mdq_messaging_visibilidad_usuario'])) : 'todos');
    }

    $numero = get_option('mdq_messaging_numero', '');
    $icono = get_option('mdq_messaging_icono', plugins_url('messaging-icon.png', __FILE__));
    $posicion = get_option('mdq_messaging_posicion', 'bottom-right');
    $mostrar_movil = get_option('mdq_messaging_mostrar_movil', 1);
    $mostrar_escritorio = get_option('mdq_messaging_mostrar_escritorio', 1);
    $mensaje = get_option('mdq_messaging_mensaje', 'Hola, necesito más información.');
    $tamano = get_option('mdq_messaging_tamano', '50px');
    $altura = get_option('mdq_messaging_altura', '20px');
    $animacion = get_option('mdq_messaging_animacion', 'none');
    $mensajes_paginas = get_option('mdq_messaging_mensajes_paginas', '');
    $visibilidad_usuario = get_option('mdq_messaging_visibilidad_usuario', 'todos');

    echo '<div class="wrap">
            <h1>Configuración del MDQ Botón de Mensajería</h1>
            <form method="post">
                ' . wp_nonce_field('mdq_messaging_button_guardar_nonce', '_wpnonce', true, false) . '
                <table class="form-table">
                    <tr valign="top">
                        <th scope="row">Número de contacto:</th>
                        <td><input type="text" name="mdq_messaging_numero" value="' . esc_attr($numero) . '" class="regular-text" placeholder="+598XXXXXXXX"></td>
                    </tr>
                    <tr valign="top">
                        <th scope="row">URL del ícono:</th>
                        <td><input type="text" name="mdq_messaging_icono" value="' . esc_attr($icono) . '" class="regular-text" placeholder="URL del ícono"></td>
                    </tr>
                    <tr valign="top">
                        <th scope="row">Posición del botón:</th>
                        <td>
                            <select name="mdq_messaging_posicion">
                                <option value="bottom-right" ' . selected($posicion, 'bottom-right', false) . '>Inferior Derecha</option>
                                <option value="bottom-left" ' . selected($posicion, 'bottom-left', false) . '>Inferior Izquierda</option>
                            </select>
                        </td>
                    </tr>
                    <tr valign="top">
                        <th scope="row">Altura desde abajo:</th>
                        <td><input type="text" name="mdq_messaging_altura" value="' . esc_attr($altura) . '" class="regular-text" placeholder="20px"></td>
                    </tr>
                    <tr valign="top">
                        <th scope="row">Mostrar en dispositivos móviles:</th>
                        <td><input type="checkbox" name="mdq_messaging_mostrar_movil" ' . checked(1, $mostrar_movil, false) . '></td>
                    </tr>
                    <tr valign="top">
                        <th scope="row">Mostrar en dispositivos de escritorio:</th>
                        <td><input type="checkbox" name="mdq_messaging_mostrar_escritorio" ' . checked(1, $mostrar_escritorio, false) . '></td>
                    </tr>
                    <tr valign="top">
                        <th scope="row">Mensaje predefinido:</th>
                        <td><input type="text" name="mdq_messaging_mensaje" value="' . esc_attr($mensaje) . '" class="regular-text" placeholder="Hola, necesito más información."></td>
                    </tr>
                    <tr valign="top">
                        <th scope="row">Tamaño del botón:</th>
                        <td><input type="text" name="mdq_messaging_tamano" value="' . esc_attr($tamano) . '" class="regular-text" placeholder="50px"></td>
                    </tr>
                    <tr valign="top">
                        <th scope="row">Animación del botón:</th>
                        <td>
                            <select name="mdq_messaging_animacion">
                                <option value="none" ' . selected($animacion, 'none', false) . '>Sin Animación</option>
                                <option value="bounce" ' . selected($animacion, 'bounce', false) . '>Rebotar</option>
                                <option value="shake" ' . selected($animacion, 'shake', false) . '>Sacudir</option>
                            </select>
                        </td>
                    </tr>
                    <tr valign="top">
                        <th scope="row">Mensajes personalizados por página:</th>
                        <td><textarea name="mdq_messaging_mensajes_paginas" class="large-text" rows="5" placeholder="/pagina-ejemplo: Hola, me interesa esta página.">' . esc_textarea($mensajes_paginas) . '</textarea><br><small>Define mensajes específicos por URL en cada línea con el formato: /slug-de-pagina: Mensaje personalizado.</small></td>
                    </tr>
                    <tr valign="top">
                        <th scope="row">Visibilidad según tipo de usuario:</th>
                        <td>
                            <select name="mdq_messaging_visibilidad_usuario">
                                <option value="todos" ' . selected($visibilidad_usuario, 'todos', false) . '>Todos los usuarios</option>
                                <option value="conectados" ' . selected($visibilidad_usuario, 'conectados', false) . '>Usuarios Conectados</option>
                                <option value="desconectados" ' . selected($visibilidad_usuario, 'desconectados', false) . '>Usuarios Desconectados</option>
                            </select>
                        </td>
                    </tr>
                </table>
                <p class="submit"><input type="submit" name="mdq_messaging_button_guardar" class="button-primary" value="Guardar Cambios"></p>
            </form>
          </div>';
}

// Agregar el botón de mensajería al sitio
add_action('wp_footer', 'mdq_agregar_messaging_boton');
function mdq_agregar_messaging_boton() {
    $numero = get_option('mdq_messaging_numero', '');
    $icono = get_option('mdq_messaging_icono', plugins_url('messaging-icon.png', __FILE__));
    $posicion = get_option('mdq_messaging_posicion', 'bottom-right');
    $mostrar_movil = get_option('mdq_messaging_mostrar_movil', 1);
    $mostrar_escritorio = get_option('mdq_messaging_mostrar_escritorio', 1);
    $mensaje = get_option('mdq_messaging_mensaje', 'Hola, necesito más información.');
    $tamano = get_option('mdq_messaging_tamano', '50px');
    $altura = get_option('mdq_messaging_altura', '20px');
    $animacion = get_option('mdq_messaging_animacion', 'none');
    $mensajes_paginas = get_option('mdq_messaging_mensajes_paginas', '');
    $visibilidad_usuario = get_option('mdq_messaging_visibilidad_usuario', 'todos');

    if (!$numero) {
        return;
    }

    // Verificar la visibilidad según el tipo de usuario
    if ($visibilidad_usuario === 'conectados' && !is_user_logged_in()) {
        return;
    }
    if ($visibilidad_usuario === 'desconectados' && is_user_logged_in()) {
        return;
    }

    $posicion_css = $posicion === 'bottom-right' ? 'bottom: ' . esc_attr($altura) . '; right: 20px;' : 'bottom: ' . esc_attr($altura) . '; left: 20px;';
    $mensaje_encoded = urlencode($mensaje);

    // Comprobar si hay un mensaje específico para la URL actual
    if (!empty($mensajes_paginas)) {
        if (isset($_SERVER['REQUEST_URI'])) {
            $url_actual = rtrim(wp_parse_url(wp_unslash($_SERVER['REQUEST_URI']), PHP_URL_PATH), '/');
            $mensajes = explode("\n", $mensajes_paginas);
            foreach ($mensajes as $mensaje_pagina) {
                $mensaje_pagina = trim($mensaje_pagina);
                if (strpos($mensaje_pagina, ':') !== false) {
                    list($slug, $mensaje_personalizado) = explode(':', $mensaje_pagina, 2);
                    if (trim($slug) === $url_actual) {
                        $mensaje_encoded = urlencode(trim($mensaje_personalizado));
                        break;
                    }
                }
            }
        }
    }

    $animacion_css = '';
    if ($animacion === 'bounce') {
        $animacion_css = 'animation: bounce 2s infinite;';
    } elseif ($animacion === 'shake') {
        $animacion_css = 'animation: shake 0.5s infinite;';
    }

    echo '<style>
            @media (max-width: 768px) {
                .mdq-messaging-boton {
                    display: ' . ($mostrar_movil ? 'block' : 'none') . ';
                }
            }
            @media (min-width: 769px) {
                .mdq-messaging-boton {
                    display: ' . ($mostrar_escritorio ? 'block' : 'none') . ';
                }
            }
            @keyframes bounce {
                0%, 20%, 50%, 80%, 100% {transform: translateY(0);}
                40% {transform: translateY(-10px);}
                60% {transform: translateY(-5px);}
            }
            @keyframes shake {
                0%, 100% {transform: translateX(0);}
                10%, 30%, 50%, 70%, 90% {transform: translateX(-10px);}
                20%, 40%, 60%, 80% {transform: translateX(10px);}
            }
          </style>';

    echo '<a href="https://wa.me/' . esc_attr($numero) . '?text=' . esc_attr($mensaje_encoded) . '" target="_blank" class="mdq-messaging-boton" style="position: fixed; ' . esc_attr($posicion_css) . ' z-index: 9999; width: ' . esc_attr($tamano) . '; height: ' . esc_attr($tamano) . '; ' . esc_attr($animacion_css) . '">
            <img src="' . esc_url($icono) . '" alt="Botón de Mensajería" style="width: 100%; height: 100%;">
          </a>';
}
?>
