<div class="wrap mdq-settings-container">
    <!-- DIV Superior Logo y Titulo -->
    <div class="mdq-header-container">
        <div class="mdq-header-left">
            <img src="<?php echo plugin_dir_url(__FILE__) . 'MDQ-Sitio-en-Mantenimiento.jpg'; ?>" alt="<?php esc_attr_e('MDQ Sitio en Mantenimiento', 'mdq-sitio-en-mantenimiento'); ?>" class="mdq-plugin-icon">
        </div>
        <div class="mdq-header-right">
            <h1 class="mdq-plugin-title"><?php esc_html_e('MDQ Sitio en Mantenimiento', 'mdq-sitio-en-mantenimiento'); ?></h1>
            <p><?php esc_html_e('Gestiona el modo mantenimiento de tu sitio con opciones avanzadas de bloqueo.', 'mdq-sitio-en-mantenimiento'); ?></p>
        </div>
    </div>

    <!-- Estilos CSS Directos -->
    <style>
        .mdq-header-container {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
            background: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
        }
        .mdq-plugin-icon {
            width: 94px;
            height: 94px;
            border-radius: 8px;
        }
        .mdq-header-right h1 {
            font-size: 24px;
            margin: 0;
        }
        .mdq-header-right p {
            font-size: 14px;
            color: #666;
        }
        .mdq-settings-container {
            background: #f9f9f9;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 20px;
        }
        .mdq-success-message {
            background: #dff0d8;
            color: #3c763d;
            padding: 10px 15px;
            border: 1px solid #d6e9c6;
            border-radius: 5px;
            margin-bottom: 15px;
        }
    </style>

    <!-- Mensaje de xito -->
    <?php settings_errors('mdq_mantenimiento_messages'); ?>

    <!-- Hora del servidor -->
    <div style="margin-bottom: 20px;">
        <strong><?php echo esc_html__('Hora actual del servidor:', 'mdq-sitio-en-mantenimiento'); ?></strong> 
        <?php echo esc_html(gmdate('Y-m-d H:i:s')); ?>
    </div>

    <!-- Formulario -->
    <form method="POST">
        <?php wp_nonce_field('mdq_mantenimiento_action', 'mdq_mantenimiento_nonce'); ?>
        <table class="form-table">
            <tr>
                <th><?php esc_html_e('Modo de Bloqueo', 'mdq-sitio-en-mantenimiento'); ?></th>
                <td>
                    <select id="mdq_modo_bloqueo" name="mdq_modo_bloqueo">
                        <option value="todo" <?php selected(get_option('mdq_modo_bloqueo', 'todo'), 'todo'); ?>>
                            <?php esc_html_e('Bloquear Todo el Sitio', 'mdq-sitio-en-mantenimiento'); ?>
                        </option>
                        <option value="none" <?php selected(get_option('mdq_modo_bloqueo', 'todo'), 'none'); ?>>
                            <?php esc_html_e('Desbloquear Todo', 'mdq-sitio-en-mantenimiento'); ?>
                        </option>
                        <option value="categorias" <?php selected(get_option('mdq_modo_bloqueo', 'todo'), 'categorias'); ?>>
                            <?php esc_html_e('Bloquear Categorias', 'mdq-sitio-en-mantenimiento'); ?>
                        </option>
                        <option value="paginas" <?php selected(get_option('mdq_modo_bloqueo', 'todo'), 'paginas'); ?>>
                            <?php esc_html_e('Bloquear Paginas', 'mdq-sitio-en-mantenimiento'); ?>
                        </option>
                    </select>
                </td>
            </tr>
            <tr id="mdq-categorias-row" style="display: none;">
                <th><?php esc_html_e('Categoras Bloqueadas', 'mdq-sitio-en-mantenimiento'); ?></th>
                <td>
                    <?php 
                    $categories = get_categories(['hide_empty' => false]);
                    foreach ($categories as $category) {
                        $checked = in_array($category->term_id, get_option('mdq_categorias_bloqueadas', [])) ? 'checked' : '';
                        echo '<label><input type="checkbox" name="mdq_categorias_bloqueadas[]" value="' . esc_attr($category->term_id) . '" ' . $checked . '> ' . esc_html($category->name) . '</label><br>';
                    }
                    ?>
                </td>
            </tr>
            <tr id="mdq-paginas-row" style="display: none;">
                <th><?php esc_html_e('Pginas Bloqueadas', 'mdq-sitio-en-mantenimiento'); ?></th>
                <td>
                    <?php
                    $pages = get_pages();
                    foreach ($pages as $page) {
                        $checked = in_array($page->ID, get_option('mdq_paginas_bloqueadas', [])) ? 'checked' : '';
                        echo '<label><input type="checkbox" name="mdq_paginas_bloqueadas[]" value="' . esc_attr($page->ID) . '" ' . $checked . '> ' . esc_html($page->post_title) . '</label><br>';
                    }
                    ?>
                </td>
            </tr>
            <tr>
                <th><?php esc_html_e('Mensaje de Mantenimiento', 'mdq-sitio-en-mantenimiento'); ?></th>
                <td>
                    <input type="text" name="mdq_mensaje_mantenimiento" 
                        value="<?php echo esc_attr(get_option('mdq_mensaje_mantenimiento', 'Estamos en mantenimiento. Volvemos pronto.')); ?>" 
                        class="regular-text">
                </td>
            </tr>
            <tr>
                <th><?php esc_html_e('Imagen de Mantenimiento', 'mdq-sitio-en-mantenimiento'); ?></th>
                <td>
                    <input type="text" id="mdq_imagen_mantenimiento" name="mdq_imagen_mantenimiento" 
                        value="<?php echo esc_url(get_option('mdq_imagen_mantenimiento', '')); ?>" 
                        class="regular-text">
                    <button type="button" class="button mdq-button" id="mdq_seleccionar_imagen">
                        <?php esc_html_e('Seleccionar Imagen', 'mdq-sitio-en-mantenimiento'); ?>
                    </button>
                    <p class="mdq-description">
                        <?php esc_html_e('Si no seleccionas una imagen, se usar la imagen predeterminada.', 'mdq-sitio-en-mantenimiento'); ?>
                    </p>
                </td>
            </tr>
            <tr>
                <th><?php esc_html_e('Programar Mantenimiento', 'mdq-sitio-en-mantenimiento'); ?></th>
                <td>
                    <?php esc_html_e('Inicio:', 'mdq-sitio-en-mantenimiento'); ?> 
                    <input type="datetime-local" name="mdq_inicio_mantenimiento" 
                        value="<?php echo esc_attr(get_option('mdq_inicio_mantenimiento', '')); ?>">
                    <?php esc_html_e('Fin:', 'mdq-sitio-en-mantenimiento'); ?> 
                    <input type="datetime-local" name="mdq_fin_mantenimiento" 
                        value="<?php echo esc_attr(get_option('mdq_fin_mantenimiento', '')); ?>">
                </td>
            </tr>
        </table>
        <?php submit_button(esc_html__('Guardar Cambios', 'mdq-sitio-en-mantenimiento'), 'primary', 'mdq_guardar'); ?>
    </form>

    <!-- Script para mostrar/ocultar filas -->
    <script>
        document.getElementById('mdq_modo_bloqueo').addEventListener('change', function () {
            document.getElementById('mdq-categorias-row').style.display = this.value === 'categorias' ? 'table-row' : 'none';
            document.getElementById('mdq-paginas-row').style.display = this.value === 'paginas' ? 'table-row' : 'none';
        });

        // Inicializacin
        document.getElementById('mdq_modo_bloqueo').dispatchEvent(new Event('change'));
    </script>
</div>