<?php
/**
 * Plugin Name: MDQ Login
 * Plugin URI:  https://www.mundodequimeras.com
 * Description: Personaliza la pantalla de acceso (login, registro, recuperar contraseña) de WordPress con opciones de configuración (logo, colores, radio de borde). También mueve enlaces, selector de idioma y el mensaje de registro al interior del recuadro.
 * Version:     1.1
 * Author:      Diego Lazo
 * Author URI:  https://www.mundodequimeras.com
 * License:     GPL2
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Evitar acceso directo
}

// Incluye el archivo que gestiona el panel de administración (Settings API).
require_once plugin_dir_path(__FILE__) . 'admin/mdq-login-admin.php';

/**
 * 1. Inyecta estilos en todas las pantallas de login, registro, recuperar contraseña, etc.
 */
function mdq_login_custom_styles() {
    $options           = get_option( 'mdq_login_options' );
    $bg_color          = isset( $options['bg_color'] ) ? $options['bg_color'] : '#0073aa';
    $form_bgcolor      = isset( $options['form_bgcolor'] ) ? $options['form_bgcolor'] : '#ffffff';
    $logo_url          = isset( $options['logo_url'] ) ? $options['logo_url'] : '';
    $form_textcolor    = isset( $options['form_textcolor'] ) ? $options['form_textcolor'] : '#000000';
    $form_borderradius = isset( $options['form_borderradius'] ) ? $options['form_borderradius'] : '0';
    ?>
    <style type="text/css">
    /* Fondo general de la pantalla */
    body.login {
        background-color: <?php echo esc_html($bg_color); ?> !important;
    }
    /* Mensajes de WP (ej. "Regístrate en este sitio", "Introduce tu correo...") */
    .login .message,
    .login .error,
    .login .success {
        background: <?php echo esc_html($form_bgcolor); ?> !important;
        border-radius: <?php echo esc_html($form_borderradius); ?>px !important;
        color: <?php echo esc_html($form_textcolor); ?> !important;
        margin-bottom: 20px;
        padding: 1em;
    }
    /* Logo personalizado */
    body.login #login h1 a {
        <?php if ( $logo_url ) : ?>
            background-image: url('<?php echo esc_url($logo_url); ?>') !important;
            background-size: contain !important;
        <?php endif; ?>
        width: 320px;
        height: 80px;
    }
    /* TODOS los formularios (login, register, lostpassword, resetpass) */
    .login form {
        background: <?php echo esc_html($form_bgcolor); ?> !important;
        border-radius: <?php echo esc_html($form_borderradius); ?>px !important;
        padding-bottom: 2em; /* Espacio extra para enlaces dentro */
    }
    /* Color del texto en inputs, labels */
    .login form label,
    .login form .input,
    .login form input[type="text"],
    .login form input[type="password"],
    .login form input[type="email"] {
        color: <?php echo esc_html($form_textcolor); ?> !important;
    }
    .login form .input::placeholder {
        color: <?php echo esc_html($form_textcolor); ?> !important;
        opacity: 0.7;
    }
    </style>
    <?php
}
add_action('login_enqueue_scripts', 'mdq_login_custom_styles');

/**
 * 2. Mueve #nav, #backtoblog y .language-switcher dentro del formulario (login, register, etc.),
 *    debajo del botón de submit.
 */
function mdq_login_relocate_elements() {
    ?>
    <script>
    jQuery(document).ready(function($){
        var $nav        = $('#nav');         // "¿Has olvidado tu contraseña?"
        var $backtoblog = $('#backtoblog');  // "← Ir a..."
        var $lang       = $('.language-switcher'); // Selector de idioma

        function relocateInForm(formSelector) {
            var $form = $(formSelector);
            if ($form.length) {
                var $submit = $form.find('p.submit');
                if ($submit.length) {
                    if ($nav.length) {
                        $nav.insertAfter($submit);
                    }
                    if ($backtoblog.length) {
                        $backtoblog.insertAfter($submit);
                    }
                    if ($lang.length) {
                        $lang.insertAfter($submit);
                    }
                }
            }
        }

        // Aplicamos en cada formulario posible
        relocateInForm('#loginform');         // Login principal
        relocateInForm('#lostpasswordform');  // Recuperar contraseña
        relocateInForm('#registerform');      // Registro
        relocateInForm('#resetpassform');     // Restablecer contraseña
    });
    </script>
    <?php
}
add_action('login_footer', 'mdq_login_relocate_elements', 20);

/**
 * 3. Mueve la .message (ej. "Regístrate en este sitio") dentro del recuadro de #registerform,
 *    de modo que aparezca igual que en el login.
 */
function mdq_login_move_register_message_inside() {
    ?>
    <script>
    jQuery(document).ready(function($){
        var $registerForm = $('#registerform');
        var $messageBlock = $('.login .message'); // Bloque "Regístrate en este sitio"

        if ($registerForm.length && $messageBlock.length) {
            // Ejemplo: lo insertamos antes del botón "Registro" (p.submit)
            var $submit = $registerForm.find('p.submit');
            if ($submit.length) {
                $messageBlock.insertBefore($submit);
            }
            // Si prefieres al principio del form, usar: $messageBlock.prependTo($registerForm);
        }
    });
    </script>
    <?php
}
add_action('login_footer', 'mdq_login_move_register_message_inside', 30);

/**
 * 4. Ajusta el enlace y título del logo (por defecto apunta a wordpress.org).
 */
function mdq_login_logo_url() {
    return home_url();
}
add_filter('login_headerurl', 'mdq_login_logo_url');

function mdq_login_logo_title() {
    return get_bloginfo('name');
}
add_filter('login_headertext', 'mdq_login_logo_title');
