<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Evita acceso directo
}

function mdq_login_add_admin_menu() {
    add_options_page(
        'MDQ Login Settings',
        'MDQ Login',
        'manage_options',
        'mdq_login_settings',
        'mdq_login_settings_page_content'
    );
}
add_action( 'admin_menu', 'mdq_login_add_admin_menu' );

function mdq_login_register_settings() {
    register_setting( 'mdq_login_settings_group', 'mdq_login_options' );

    add_settings_section(
        'mdq_login_main_section',
        'Opciones de MDQ Login',
        'mdq_login_main_section_cb',
        'mdq_login_settings'
    );

    // Campo: color de fondo (pantalla)
    add_settings_field(
        'mdq_bg_color',
        'Color de fondo (pantalla)',
        'mdq_login_bg_color_field_cb',
        'mdq_login_settings',
        'mdq_login_main_section'
    );

    // Campo: color de fondo (formulario)
    add_settings_field(
        'mdq_form_bgcolor',
        'Color de fondo (formulario)',
        'mdq_login_form_bgcolor_field_cb',
        'mdq_login_settings',
        'mdq_login_main_section'
    );

    // Campo: logo personalizado
    add_settings_field(
        'mdq_logo_url',
        'Logo personalizado',
        'mdq_login_logo_url_field_cb',
        'mdq_login_settings',
        'mdq_login_main_section'
    );

    // Campo: color del texto en el formulario
    add_settings_field(
        'mdq_form_textcolor',
        'Color del texto (formulario)',
        'mdq_login_form_textcolor_field_cb',
        'mdq_login_settings',
        'mdq_login_main_section'
    );

    // Campo: radio de borde
    add_settings_field(
        'mdq_form_borderradius',
        'Radio del borde (formulario)',
        'mdq_login_form_borderradius_field_cb',
        'mdq_login_settings',
        'mdq_login_main_section'
    );
}
add_action( 'admin_init', 'mdq_login_register_settings' );

/*
function mdq_login_options_sanitize($input) {
    // Podrías validar/sanitizar aquí si gustas
    return $input;
}
*/

function mdq_login_main_section_cb() {
    echo '<p>Configura los colores, el logo y el radio de borde para la pantalla de login, registro y recuperar contraseña.</p>';
}

// Color de fondo (pantalla)
function mdq_login_bg_color_field_cb() {
    $options  = get_option( 'mdq_login_options' );
    $bg_color = isset( $options['bg_color'] ) ? $options['bg_color'] : '#0073aa';
    ?>
    <input 
        type="text" 
        name="mdq_login_options[bg_color]" 
        value="<?php echo esc_attr($bg_color); ?>" 
        class="mdq-color-field" 
    />
    <p class="description">Color de fondo de toda la pantalla de login.</p>
    <?php
}

// Color de fondo (formulario)
function mdq_login_form_bgcolor_field_cb() {
    $options      = get_option( 'mdq_login_options' );
    $form_bgcolor = isset( $options['form_bgcolor'] ) ? $options['form_bgcolor'] : '#ffffff';
    ?>
    <input 
        type="text" 
        name="mdq_login_options[form_bgcolor]" 
        value="<?php echo esc_attr($form_bgcolor); ?>" 
        class="mdq-color-field"
    />
    <p class="description">Color del recuadro del formulario.</p>
    <?php
}

// Logo personalizado
function mdq_login_logo_url_field_cb() {
    $options  = get_option( 'mdq_login_options' );
    $logo_url = isset( $options['logo_url'] ) ? $options['logo_url'] : '';
    ?>
    <input 
        type="text" 
        name="mdq_login_options[logo_url]" 
        id="mdq_logo_url" 
        value="<?php echo esc_url($logo_url); ?>" 
        style="width: 70%" 
    />
    <button type="button" class="button" id="mdq_logo_upload_btn">Subir/Seleccionar Imagen</button>
    <p class="description">Pega la URL de tu logo o usa el botón para subir/seleccionar en la librería de medios.</p>
    <?php
}

// Color del texto (formulario)
function mdq_login_form_textcolor_field_cb() {
    $options        = get_option( 'mdq_login_options' );
    $form_textcolor = isset( $options['form_textcolor'] ) ? $options['form_textcolor'] : '#000000';
    ?>
    <input 
        type="text" 
        name="mdq_login_options[form_textcolor]" 
        value="<?php echo esc_attr($form_textcolor); ?>" 
        class="mdq-color-field"
    />
    <p class="description">Color de labels, inputs y placeholders.</p>
    <?php
}

// Radio del borde (formulario)
function mdq_login_form_borderradius_field_cb() {
    $options           = get_option( 'mdq_login_options' );
    $form_borderradius = isset( $options['form_borderradius'] ) ? $options['form_borderradius'] : '0';
    ?>
    <input 
        type="number" 
        name="mdq_login_options[form_borderradius]" 
        value="<?php echo esc_attr($form_borderradius); ?>" 
        style="width: 60px"
    />
    <p class="description">Define el radio del borde del formulario (en píxeles). Ej: 10</p>
    <?php
}

function mdq_login_settings_page_content() {
    ?>
    <div class="wrap">
        <h1>Configuración de MDQ Login</h1>
        <form method="post" action="options.php">
            <?php
                settings_fields( 'mdq_login_settings_group' );
                do_settings_sections( 'mdq_login_settings' );
                submit_button();
            ?>
        </form>
    </div>
    <?php
}

function mdq_login_admin_assets( $hook_suffix ) {
    if ( 'settings_page_mdq_login_settings' !== $hook_suffix ) {
        return;
    }
    wp_enqueue_media();
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_script(
        'mdq-login-admin-js',
        plugin_dir_url(__FILE__) . 'mdq-login-admin.js',
        array( 'wp-color-picker', 'jquery' ),
        '1.0',
        true
    );
}
add_action( 'admin_enqueue_scripts', 'mdq_login_admin_assets' );
